//+------------------------------------------------------------------+
//|                                                     T3 clean.mq4 |
//+------------------------------------------------------------------+
#property copyright ""
#property link      ""

#property indicator_chart_window
#property indicator_buffers 1
#property indicator_color1 Red
#property indicator_width1 3

extern int    T3_Period = 14;
extern double b         = 0.618;

double t3Array[];
double ae1[];
double ae2[];
double ae3[];
double ae4[];
double ae5[];
double ae6[];

//
//
//
//
//

double e1,e2,e3,e4,e5,e6;
double c1,c2,c3,c4;
double n,w1,w2,b2,b3;


//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+

int init()
{
   IndicatorShortName("T3 Moving Average "+T3_Period);
   IndicatorDigits(MarketInfo(Symbol(),MODE_DIGITS));
   IndicatorBuffers(7);
    
   SetIndexLabel(0,"T3 "+T3_Period);
   SetIndexBuffer(0,t3Array);
   SetIndexBuffer(1,ae1);
   SetIndexBuffer(2,ae2);
   SetIndexBuffer(3,ae3);
   SetIndexBuffer(4,ae4);
   SetIndexBuffer(5,ae5);
   SetIndexBuffer(6,ae6);

   //
   //
   //
   //
   //
   //

   b2 = b*b;
   b3 = b2*b;

   c1 = -b3;
   c2 = (3*(b2+b3));
   c3 = -3*(2*b2+b+b3);
   c4 = (1+3*b+b3+3*b2);

   n=T3_Period; if (n<1) n=1;

   n  = 1 + 0.5*(n-1);
   w1 = 2 / (n + 1);
   w2 = 1 - w1;
    
   return(0);
}


//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+

int start()
{
   int limit;
   int counted_bars=IndicatorCounted();


   if(counted_bars<0) return(-1);
   if(counted_bars>0) counted_bars--;
      limit=Bars-counted_bars;
   

   //
   //
   //
   //
   //
   
   for(int i=limit; i>=0; i--)
   {
      e1 = w1*Close[i] + w2*ae1[i+1];
      e2 = w1*e1       + w2*ae2[i+1];
      e3 = w1*e2       + w2*ae3[i+1];
      e4 = w1*e3       + w2*ae4[i+1];
      e5 = w1*e4       + w2*ae5[i+1];
      e6 = w1*e5       + w2*ae6[i+1];

         t3Array[i]=c1*e6 + c2*e5 + c3*e4 + c4*e3;
         ae1[i] = e1;
         ae2[i] = e2;
         ae3[i] = e3;
         ae4[i] = e4;
         ae5[i] = e5;
         ae6[i] = e6;
   }   
   return(0);
}
//+------------------------------------------------------------------+